<?php

include('../db.php');  // আপনার ডাটাবেস কানেকশন ফাইল ইনক্লুড

// ডাটাবেস থেকে ডেটা নিন
$sql = "SELECT task_id, user_id, completed_at FROM completed_tasks ORDER BY completed_at DESC";
$result = $conn->query($sql);
// =================================================================
require_once 'includes/header.php';
$conn = $conn_header;

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Completed Tasks</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f9f9f9; margin: 0; padding: 0; }
        header, footer { background: #007BFF; color: white; padding: 15px 30px; text-align: center; }
        main { padding: 20px 30px; }
        h2 { margin-top: 0; }
        table { width: 100%; border-collapse: collapse; background: white; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        th, td { padding: 10px 15px; border: 1px solid #ccc; text-align: center; }
        th { background-color: #007BFF; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }
    </style>
</head>
<body>

<header>
    <h1>Dashboard Header</h1>
</header>

<main>
    <h2>Completed Tasks</h2>

    <table>
        <thead>
            <tr>
                <th>Task ID</th>
                <th>User ID</th>
                <th>Completed At</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result && $result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['task_id']) ?></td>
                        <td><?= htmlspecialchars($row['user_id']) ?></td>
                        <td><?= htmlspecialchars($row['completed_at']) ?></td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="3">No completed tasks found.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</main>

<footer>
   
<?php require_once 'includes/footer.php'; ?>
</footer>

</body>
</html>
