<?php
require_once 'includes/header.php'; // অথবা include('../db.php');
$conn = $conn_header;  // যদি header এ থাকে

$error = '';

$zone_id = $_GET['zone_id'] ?? '';

if (!$zone_id) {
    die("Invalid Zone ID");
}

$stmt = $conn->prepare("SELECT zone_id, reward FROM monetag_settings WHERE zone_id = ?");
$stmt->bind_param("s", $zone_id);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();

if (!$row) {
    die("Zone ID not found");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_zone_id = $_POST['zone_id'] ?? '';
    $new_reward = $_POST['reward'] ?? '';

    if ($new_zone_id == '' || $new_reward == '') {
        $error = "সব ফিল্ড পূরণ করুন।";
    } else {
        $update_stmt = $conn->prepare("UPDATE monetag_settings SET zone_id = ?, reward = ? WHERE zone_id = ?");
        $update_stmt->bind_param("sss", $new_zone_id, $new_reward, $zone_id);

        if ($update_stmt->execute()) {
            header("Location: monetag_settings.php?msg=updated");
            exit;
        } else {
            $error = "আপডেট করতে সমস্যা হয়েছে।";
        }
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Edit Monetag Setting</title>
<style>
    body { font-family: Arial, sans-serif; background: #f9f9f9; padding: 30px; }
    .container { max-width: 500px; background: white; padding: 25px; margin: auto; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); }
    h2 { color: #0056b3; }
    form { display: flex; flex-direction: column; gap: 15px; }
    label { font-weight: bold; }
    input[type="text"] { padding: 10px; font-size: 1em; border: 1.5px solid #ccc; border-radius: 5px; }
    input[type="submit"] { background-color: #0056b3; color: white; border: none; padding: 12px; font-size: 1em; border-radius: 5px; cursor: pointer; }
    input[type="submit"]:hover { background-color: #003f7f; }
    .error { background: #f8d7da; color: #721c24; padding: 10px; border-radius: 5px; margin-bottom: 15px; }
    a.back-link { display: inline-block; margin-top: 15px; text-decoration: none; color: #0056b3; }
    a.back-link:hover { text-decoration: underline; }
</style>
</head>
<body>

<div class="container">
    <h2>Edit Monetag Setting</h2>

    <?php if (!empty($error)): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" action="">
        <label for="zone_id">Zone ID:</label>
        <input type="text" id="zone_id" name="zone_id" value="<?= htmlspecialchars($row['zone_id']) ?>" required>

        <label for="reward">Reward:</label>
        <input type="text" id="reward" name="reward" value="<?= htmlspecialchars($row['reward']) ?>" required>

        <input type="submit" value="Update">
    </form>

    <a href="monetag_settings.php" class="back-link">&larr; Back to list</a>
</div>

<footer>
   
<?php require_once 'includes/footer.php'; ?>
</footer>

</body>
</html>
