<?php
require_once 'admin_init.php';


require_once 'includes/header.php';
$conn = $conn_header;
$message = '';

$user_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$user_id) {
    header("Location: users.php");
    exit();
}

// ব্যবহারকারীর তথ্য আপডেট করা
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $total_balance = filter_input(INPUT_POST, 'total_balance', FILTER_VALIDATE_FLOAT);
    // আপনি চাইলে অন্যান্য ফিল্ডও আপডেট করতে পারেন
    
    $stmt = $conn->prepare("UPDATE users SET total_balance = ? WHERE id = ?");
    $stmt->bind_param('di', $total_balance, $user_id);
    if ($stmt->execute()) {
        $message = "<div class='message success'>User data updated successfully!</div>";
    } else {
        $message = "<div class='message error'>Failed to update user data.</div>";
    }
}

// ডাটাবেস থেকে নির্দিষ্ট ব্যবহারকারীর তথ্য আনা
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param('i', $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

if (!$user) {
    echo "User not found.";
    exit();
}
?>
<style>
    .form-container { background: #fff; padding: 30px; border-radius: 8px; max-width: 600px; }
    .form-group { margin-bottom: 15px; }
    label { display: block; margin-bottom: 5px; font-weight: 500; }
    input { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; }
    .btn { padding: 12px 20px; border: none; border-radius: 5px; color: #fff; background-color: var(--primary-blue); cursor: pointer; }
    .back-link { display: inline-block; margin-bottom: 20px; color: var(--primary-blue); text-decoration: none; }
    .message { padding: 15px; margin-bottom: 20px; border-radius: 5px; }
    .success { background-color: #d4edda; color: #155724; }
    .error { background-color: #f8d7da; color: #721c24; }
</style>

<a href="users.php" class="back-link"><i class="fas fa-arrow-left"></i> Back to User List</a>
<h2>Edit User: <?php echo htmlspecialchars($user['first_name']); ?></h2>

<div class="form-container">
    <?php echo $message; ?>
    <form method="POST">
        <div class="form-group">
            <label>First Name</label>
            <input type="text" value="<?php echo htmlspecialchars($user['first_name']); ?>" disabled>
        </div>
        <div class="form-group">
            <label>Chat ID</label>
            <input type="text" value="<?php echo $user['chat_id']; ?>" disabled>
        </div>
        <div class="form-group">
            <label for="total_balance">Total Balance (SHIB)</label>
            <input type="number" step="0.01" id="total_balance" name="total_balance" value="<?php echo $user['total_balance']; ?>">
        </div>
        <!-- আপনি চাইলে আরও 필드 যোগ করতে পারেন -->
        <button type="submit" class="btn">Save Changes</button>
    </form>
</div>

<?php require_once 'includes/footer.php'; ?>