<?php
require_once 'admin_init.php';


session_start();
require_once 'includes/header.php';  // হেডার ফাইল include করুন
$conn = $conn_header;               // আপনার ডাটাবেজ কানেকশন

// নিরাপত্তার জন্য সহজ লগইন চেক (আপনার সেশন/লগিক অনুযায়ী চেঞ্জ করুন)
if (!isset($_SESSION['admin_logged_in'])) {
    echo "<p style='color:red; text-align:center; margin-top:50px;'>Access denied. Please login as admin.</p>";
    require_once 'includes/footer.php';
    exit;
}

// টেবিল চেক এবং ইনসার্ট (যদি না থাকে)
$conn->query("CREATE TABLE IF NOT EXISTS ads_settings (
    id INT PRIMARY KEY,
    project_id VARCHAR(50) NOT NULL,
    ad_amount DECIMAL(10,3) NOT NULL DEFAULT 0.008
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
$conn->query("INSERT IGNORE INTO ads_settings (id, project_id, ad_amount) VALUES (1, '1107', 0.008)");

// আপডেট প্রক্রিয়া
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $project_id = trim($_POST['project_id'] ?? '');
    $ad_amount = floatval($_POST['ad_amount'] ?? 0);

    if ($project_id !== '' && $ad_amount > 0) {
        $stmt = $conn->prepare("UPDATE ads_settings SET project_id = ?, ad_amount = ? WHERE id = 1");
        $stmt->bind_param("sd", $project_id, $ad_amount);
        if ($stmt->execute()) {
            $_SESSION['message'] = "<div class='message success'>Settings updated successfully.</div>";
        } else {
            $_SESSION['message'] = "<div class='message error'>Update failed: " . htmlspecialchars($stmt->error) . "</div>";
        }
        $stmt->close();
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    } else {
        $_SESSION['message'] = "<div class='message error'>Please provide valid inputs.</div>";
        header("Location: " . $_SERVER['PHP_SELF']);
        exit;
    }
}

// ডাটাবেস থেকে সেটিংস লোড
$result = $conn->query("SELECT project_id, ad_amount FROM ads_settings WHERE id = 1 LIMIT 1");
$settings = $result->fetch_assoc();

?>

<style>
.container {
    max-width: 400px;
    margin: 60px auto;
    background: #223054;
    padding: 30px;
    border-radius: 12px;
    color: white;
    font-family: 'Hind Siliguri', sans-serif;
}
label {
    display: block;
    margin-top: 15px;
    font-weight: 700;
    font-size: 14px;
    color: #ddd;
}
input[type=text], input[type=number] {
    width: 100%;
    padding: 10px;
    margin-top: 5px;
    border: none;
    border-radius: 6px;
    font-size: 16px;
    box-sizing: border-box;
}
button {
    margin-top: 25px;
    width: 100%;
    padding: 12px;
    background: #00e5ff;
    color: #000;
    border: none;
    font-weight: 700;
    font-size: 18px;
    border-radius: 8px;
    cursor: pointer;
    transition: background-color 0.3s ease;
}
button:hover {
    background: #00c2d9;
}
.message {
    margin-bottom: 15px;
    font-weight: 700;
    text-align: center;
}
.success {
    color: #a2f5a2;
}
.error {
    color: #f56969;
}
</style>

<div class="container">
    <h2>Project ID এবং প্রতি Ads এর টাকা চেঞ্জ করুন</h2>

    <?php
    if (!empty($_SESSION['message'])) {
        echo $_SESSION['message'];
        unset($_SESSION['message']);
    }
    ?>

    <form method="post">
        <label for="project_id">Project ID:</label>
        <input type="text" id="project_id" name="project_id" required value="<?= htmlspecialchars($settings['project_id'] ?? '') ?>" />

        <label for="ad_amount">প্রতি Ads এর টাকা (৳):</label>
        <input type="number" id="ad_amount" name="ad_amount" step="0.001" min="0.001" required value="<?= htmlspecialchars($settings['ad_amount'] ?? 0.008) ?>" />

        <button type="submit">আপডেট করুন</button>
    </form>
</div>

<?php
require_once 'includes/footer.php';  // ফুটার ফাইল include করুন
?>