<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}
require_once '../config.php';
$conn_header = require_once '../db.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    <style>
        :root { 
            --primary-blue: #007BFF; 
            --primary-green: #28A745; 
            --primary-yellow: #FFC107; 
            --bg-light: #f8f9fa; 
            --text-dark: #343a40; 
            --text-light: #f8f9fa;
            --white: #fff; 
            --grey: #e9ecef;
            
            /* নতুন এবং উন্নত সাইডবার কালার */
            --sidebar-bg: #111827; /* গাঢ় নীল */
            --sidebar-link-color: #d1d5db; /* হালকা ধূসর টেক্সট */
            --sidebar-hover-bg: #1f2937; /* হোভারের জন্য সামান্য হালকা রঙ */
            --sidebar-active-bg: #007BFF; /* সক্রিয় লিঙ্কের জন্য উজ্জ্বল নীল */
            --sidebar-section-header: #6b7280; /* বিভাগ শিরোনামের জন্য রঙ */
        }
        body { 
            margin: 0; 
            font-family: 'Poppins', sans-serif; 
            background-color: var(--bg-light); 
            color: var(--text-dark);
        }
        .top-bar { 
            background: var(--white); 
            padding: 12px 25px; 
            display: flex; 
            justify-content: space-between; 
            align-items: center; 
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            position: sticky;
            top: 0;
            z-index: 1000;
        }
        .menu-toggle { 
            font-size: 2em; 
            cursor: pointer;
            color: var(--text-dark);
        }
        .user-menu {
            display: flex;
            align-items: center;
            gap: 15px; /* আইটেমগুলির মধ্যে ফাঁক */
        }
        .user-menu .welcome-text {
            font-weight: 500;
            font-size: 0.95em;
        }
        .user-menu .user-icon {
            font-size: 1.6em;
            color: var(--primary-blue);
        }
        .user-menu .logout-link {
            display: flex;
            align-items: center;
            text-decoration: none;
            color: var(--primary-blue);
            font-weight: 500;
            background-color: #e7f3ff;
            padding: 8px 15px;
            border-radius: 20px;
            transition: all 0.3s ease;
        }
        .user-menu .logout-link:hover {
            background-color: var(--primary-blue);
            color: var(--white);
        }
        .user-menu .logout-link i {
            margin-right: 8px;
        }

        .side-nav { 
            height: 100%; 
            width: 0; 
            position: fixed; 
            z-index: 1001; 
            top: 0; 
            left: 0; 
            background-color: var(--sidebar-bg); 
            overflow-x: hidden; 
            transition: 0.3s ease-in-out; 
            padding-top: 20px;
            box-shadow: 4px 0 20px rgba(0,0,0,0.2);
            border-right: 1px solid #2d3748;
        }
        .side-nav .dashboard-title {
            color: var(--white);
            padding: 0 30px;
            margin-bottom: 25px;
            font-size: 1.5em;
            font-weight: 600;
        }
        .side-nav a { 
            padding: 15px 20px 15px 30px; 
            text-decoration: none; 
            font-size: 1em;
            font-weight: 500;
            color: var(--sidebar-link-color); 
            display: flex; /* Flexbox ব্যবহার করে আইকন এবং টেক্সট অ্যালাইন করা */
            align-items: center;
            transition: background-color 0.3s, color 0.3s, border-left-color 0.3s;
            border-left: 4px solid transparent;
            margin: 5px 0;
        }
        .side-nav a:hover { 
            color: var(--white);
            background-color: var(--sidebar-hover-bg);
            border-left-color: var(--primary-blue);
        }
        .side-nav a.active { /* সক্রিয় লিঙ্কের জন্য স্টাইল */
            background: var(--sidebar-active-bg);
            color: var(--white);
            border-left-color: #fff;
        }
        .side-nav .close-btn { 
            position: absolute; 
            top: 15px; 
            right: 20px; 
            font-size: 2em; 
            color: var(--sidebar-link-color);
            cursor: pointer;
        }
        .side-nav a i { 
            margin-right: 15px;
            width: 22px; 
            text-align: center;
            font-size: 1.1em;
        }
        .side-nav .section-header {
            padding: 12px 30px;
            color: var(--sidebar-section-header);
            font-weight: 700;
            font-size: 0.8em;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-top: 20px;
            margin-bottom: 5px;
        }

        .content { 
            transition: margin-left .3s ease-in-out; 
            padding: 25px;
        }
        
        .stat-card { color: var(--white); border-radius: 12px; padding: 25px; margin-bottom: 25px; box-shadow: 0 8px 25px rgba(0,0,0,0.1); transition: transform 0.3s ease, box-shadow 0.3s ease; }
        .stat-card:hover { transform: translateY(-8px); box-shadow: 0 12px 30px rgba(0,0,0,0.15); }
        .bg-blue { background: linear-gradient(135deg, #007BFF, #0056b3); }
        .bg-green { background: linear-gradient(135deg, #28A745, #1e7e34); }
        .bg-yellow { background: linear-gradient(135deg, #FFC107, #d39e00); }
        .stat-card h3 { margin: 0 0 12px 0; font-weight: 500; }
        .stat-card .value { font-size: 2.8em; font-weight: 700; }
        .stat-card p { margin: 8px 0 0; opacity: 0.9; }
    </style>
</head>
<body>
    <div id="mySidenav" class="side-nav">
        <a href="javascript:void(0)" class="close-btn" onclick="closeNav()">×</a>
        <h3 class="dashboard-title">Admin Panel</h3>
        
        <a href="index.php" class="active"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
        <a href="users.php"><i class="fas fa-users"></i> Users</a>
        <a href="withdrawals.php"><i class="fas fa-wallet"></i> Withdraws</a>
        
        <p class="section-header">TASK NETWORKS</p>
        <a href="telegram_tasks.php"><i class="fab fa-telegram-plane"></i> Telegram Tasks</a>
        <a href="monetag_settings.php"><i class="fas fa-layer-group"></i> Monetag Ads</a>
        <a href="adsterra_settings.php"><i class="fas fa-bullhorn"></i> Adsterra Ads</a>
        <a href="gigapub_settings.php"><i class="fas fa-file-alt"></i> Gigapub Ads</a>
        
        <p class="section-header">ACTIONS</p>
        <a href="notifications.php"><i class="fas fa-paper-plane"></i> Send Message</a>
        <a href="settings.php"><i class="fas fa-cog"></i> Settings</a>
        <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </div>

    <div id="main" class="content">
        <div class="top-bar">
            <span class="menu-toggle" onclick="openNav()">☰</span>
            <div class="user-menu">
                <span class="welcome-text">Welcome, <strong><?php echo htmlspecialchars($_SESSION['admin_username']); ?></strong>!</span>
                <i class="fas fa-user-circle user-icon"></i>
                <a href="logout.php" class="logout-link">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>

        <div class="main-content">
            <!-- আপনার পেজের বাকি কন্টেন্ট এখানে থাকবে -->
        </div>
    </div>

    <script>
        function openNav() {
            document.getElementById("mySidenav").style.width = "280px";
            document.getElementById("main").style.marginLeft = "280px";
        }

        function closeNav() {
            document.getElementById("mySidenav").style.width = "0";
            document.getElementById("main").style.marginLeft = "0";
        }
    </script>
</body>
</html>