<?php
require_once 'includes/header.php';  // এখানে হেডার ফাইল ইনক্লুড করুন যেখানে $conn_header তৈরি আছে
$conn = $conn_header;                // $conn_header থেকে $conn সেট করুন

$zone_search = isset($_GET['zone_id']) ? trim($_GET['zone_id']) : '';
$reward_search = isset($_GET['reward']) ? trim($_GET['reward']) : '';

// কোয়েরি প্রস্তুত
$sql = "SELECT zone_id, reward FROM monetag_settings WHERE 1";

$conditions = [];
$params = [];
$types = '';

if ($zone_search !== '') {
    $conditions[] = "zone_id LIKE ?";
    $params[] = "%$zone_search%";
    $types .= 's';
}

if ($reward_search !== '') {
    $conditions[] = "reward LIKE ?";
    $params[] = "%$reward_search%";
    $types .= 's';
}

if (count($conditions) > 0) {
    $sql .= " AND " . implode(' AND ', $conditions);
}

$stmt = $conn->prepare($sql);
if ($stmt && count($params) > 0) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// ... বাকি HTML ও কোড এখানে থাকবে
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8" />
<title>Monetag Settings</title>
<style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: #f4f7f8;
        margin: 0; padding: 0;
        color: #333;
    }
    header {
        background-color: #0056b3;
        padding: 20px;
        color: white;
        text-align: center;
        font-size: 1.8em;
        letter-spacing: 1px;
    }
    main {
        max-width: 900px;
        margin: 30px auto;
        background: white;
        padding: 25px 30px;
        border-radius: 8px;
        box-shadow: 0 6px 18px rgba(0,0,0,0.1);
    }
    h2 {
        margin-top: 0;
        margin-bottom: 20px;
        color: #0056b3;
    }
    form {
        margin-bottom: 25px;
        display: flex;
        gap: 15px;
        flex-wrap: wrap;
        align-items: center;
    }
    input[type="text"] {
        flex: 1 1 200px;
        padding: 10px 15px;
        border: 1.8px solid #ccc;
        border-radius: 5px;
        font-size: 1em;
        transition: border-color 0.3s ease;
    }
    input[type="text"]:focus {
        border-color: #0056b3;
        outline: none;
        box-shadow: 0 0 5px rgba(0,86,179,0.5);
    }
    button, .reset-btn {
        background-color: #0056b3;
        border: none;
        color: white;
        padding: 11px 22px;
        font-size: 1em;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
        user-select: none;
        text-decoration: none;
        text-align: center;
        display: inline-block;
        white-space: nowrap;
    }
    button:hover, .reset-btn:hover {
        background-color: #003f7f;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 3px 12px rgba(0,0,0,0.1);
    }
    thead {
        background: linear-gradient(45deg, #0056b3, #007bff);
        color: white;
    }
    th, td {
        padding: 12px 15px;
        text-align: center;
        border-bottom: 1px solid #e1e4e8;
        font-size: 1em;
    }
    tbody tr:nth-child(even) {
        background-color: #f9fbfd;
    }
    tbody tr:hover {
        background-color: #dbe9ff;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }
    .edit-btn {
        background-color: #28a745;
        padding: 7px 15px;
        border-radius: 5px;
        font-size: 0.9em;
        color: white;
        border: none;
        cursor: pointer;
        transition: background-color 0.3s ease;
        text-decoration: none;
        display: inline-block;
    }
    .edit-btn:hover {
        background-color: #1e7e34;
    }
</style>
</head>
<body>

<header>
    Monetag Settings
</header>

<main>
    <h2>Filter Monetag Settings</h2>
    <form method="get" action="">
        <input type="text" name="zone_id" placeholder="Search by Zone ID" value="<?= htmlspecialchars($zone_search) ?>" />
        <input type="text" name="reward" placeholder="Search by Reward" value="<?= htmlspecialchars($reward_search) ?>" />
        <button type="submit">Search</button>
        <a href="monetag_settings.php" class="reset-btn" style="margin-left:10px;">Reset</a>
    </form>

    <table>
        <thead>
            <tr>
                <th>Zone ID</th>
                <th>Reward</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result && $result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['zone_id']) ?></td>
                        <td><?= htmlspecialchars($row['reward']) ?></td>
                        <td>
                            <!-- Edit পেজে পাঠানোর জন্য লিঙ্ক (আপনার এডিট পেজ অনুযায়ী ঠিক করুন) -->
                            <a class="edit-btn" href="edit_monetag.php?zone_id=<?= urlencode($row['zone_id']) ?>">Edit</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="3">No results found.</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</main>

<footer>
   
<?php require_once 'includes/footer.php'; ?>
</footer>

</body>
</html>
