<?php
require_once 'includes/header.php';
$conn = $conn_header;
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    $stmt = $conn->prepare("SELECT password FROM admins WHERE id = ?");
    $stmt->bind_param('i', $_SESSION['admin_id']);
    $stmt->execute();
    $admin = $stmt->get_result()->fetch_assoc();

    if (password_verify($current_password, $admin['password'])) {
        if ($new_password === $confirm_password) {
            if (strlen($new_password) >= 6) {
                $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $update_stmt = $conn->prepare("UPDATE admins SET password = ? WHERE id = ?");
                $update_stmt->bind_param('si', $new_hashed_password, $_SESSION['admin_id']);
                $update_stmt->execute();
                $message = "<div class='message success'>Password updated successfully!</div>";
            } else {
                $message = "<div class='message error'>New password must be at least 6 characters long.</div>";
            }
        } else {
            $message = "<div class='message error'>New passwords do not match.</div>";
        }
    } else {
        $message = "<div class='message error'>Incorrect current password.</div>";
    }
}
?>
<style>
    .form-container { background: #fff; padding: 30px; border-radius: 8px; max-width: 500px; }
    .form-group { margin-bottom: 15px; }
    label { display: block; margin-bottom: 5px; font-weight: 500; }
    input { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; }
    .btn { padding: 12px 20px; border: none; border-radius: 5px; color: #fff; background-color: #007bff; cursor: pointer; }
    .message { padding: 15px; margin-bottom: 20px; border-radius: 5px; }
    .success { background-color: #d4edda; color: #155724; }
    .error { background-color: #f8d7da; color: #721c24; }
</style>
<h2>Change Password</h2>
<div class="form-container">
    <?php echo $message; ?>
    <form method="POST">
        <div class="form-group"><label for="current_password">Current Password</label><input type="password" name="current_password" required></div>
        <div class="form-group"><label for="new_password">New Password</label><input type="password" name="new_password" required></div>
        <div class="form-group"><label for="confirm_password">Confirm New Password</label><input type="password" name="confirm_password" required></div>
        <button type="submit" class="btn">Update Password</button>
    </form>
</div>
<?php require_once 'includes/footer.php'; ?>