<?php
require_once 'admin_init.php';
// =================================================================
// ADMIN PANEL FOR MANAGING TELEGRAM TASKS
// =================================================================
session_start();
// আপনি চাইলে এখানে একটি পাসওয়ার্ড বা লগইন সিস্টেম যোগ করতে পারেন
// define('ADMIN_PASSWORD', 'your_secure_password');
// if (!isset($_SESSION['is_admin_logged_in']) || $_SESSION['is_admin_logged_in'] !== true) {
//     // Login logic here...
// }

require_once '../config.php';
$conn = require_once '../db.php';

// --- ফর্ম হ্যান্ডেলিং ---
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_task'])) {
        $username = trim($_POST['channel_username'], '@ ');
        $channel_id = filter_input(INPUT_POST, 'channel_id', FILTER_SANITIZE_NUMBER_INT);
        $reward = filter_input(INPUT_POST, 'reward_amount', FILTER_VALIDATE_FLOAT);
        $description = trim($_POST['task_description']);

        if ($username && $channel_id && $reward) {
            $stmt = $conn->prepare("INSERT INTO telegram_tasks (channel_username, channel_id, reward_amount, task_description) VALUES (?, ?, ?, ?)");
            $stmt->bind_param('sids', $username, $channel_id, $reward, $description);
            if ($stmt->execute()) {
                $message = "<div class='message success'>New task added successfully!</div>";
            } else {
                $message = "<div class='message error'>Error: " . $stmt->error . "</div>";
            }
        } else {
            $message = "<div class='message error'>Please fill all required fields correctly.</div>";
        }
    }

    if(isset($_POST['toggle_status'])) {
        $task_id = $_POST['task_id'];
        $current_status = $_POST['current_status'];
        $new_status = ($current_status === 'active') ? 'inactive' : 'active';
        
        $stmt = $conn->prepare("UPDATE telegram_tasks SET status = ? WHERE id = ?");
        $stmt->bind_param('si', $new_status, $task_id);
        $stmt->execute();
        header("Location: index.php"); // Refresh page
        exit();
    }
}

// সকল টাস্ক ডাটাবেস থেকে আনা
$tasks = $conn->query("SELECT * FROM telegram_tasks ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Telegram Tasks</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f4f6f9; color: #333; margin: 0; padding: 20px; }
        .container { max-width: 900px; margin: 0 auto; background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1, h2 { color: #333; }
        .message { padding: 15px; margin-bottom: 20px; border-radius: 5px; }
        .success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: 500; }
        .form-group input, .form-group textarea { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; }
        .form-group small { color: #666; font-size: 0.9em; }
        .btn { padding: 12px 20px; border: none; border-radius: 5px; color: #fff; background-color: #007bff; cursor: pointer; font-size: 1em; }
        .btn:hover { background-color: #0056b3; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 30px; }
        th, td { padding: 12px; border: 1px solid #ddd; text-align: left; }
        th { background-color: #f2f2f2; }
        .status-btn { padding: 5px 10px; border: none; border-radius: 4px; color: white; cursor: pointer; }
        .active { background-color: #28a745; }
        .inactive { background-color: #dc3545; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Telegram Task Management</h1>
        
        <?php echo $message; ?>

        <h2>Add New Task</h2>
        <form action="" method="POST">
            <div class="form-grid">
                <div class="form-group">
                    <label for="channel_username">Channel Username</label>
                    <input type="text" id="channel_username" name="channel_username" placeholder="@yourchannel" required>
                    <small>Do not include the "@" symbol.</small>
                </div>
                <div class="form-group">
                    <label for="channel_id">Channel ID</label>
                    <input type="text" id="channel_id" name="channel_id" placeholder="-100xxxxxxxxxx" required>
                    <small>Must start with "-100". Get it from @userinfobot.</small>
                </div>
                <div class="form-group">
                    <label for="reward_amount">Reward Amount (SHIB)</label>
                    <input type="number" step="0.01" id="reward_amount" name="reward_amount" placeholder="e.g., 10.00" required>
                </div>
                <div class="form-group">
                    <label for="task_description">Task Description</label>
                    <input type="text" id="task_description" name="task_description" value="Join channel to earn">
                </div>
            </div>
            <button type="submit" name="add_task" class="btn">Add Task</button>
        </form>

        <hr style="margin: 40px 0;">

        <h2>Existing Tasks</h2>
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Channel</th>
                    <th>Channel ID</th>
                    <th>Reward</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while($task = $tasks->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $task['id']; ?></td>
                    <td>@<?php echo htmlspecialchars($task['channel_username']); ?></td>
                    <td><?php echo $task['channel_id']; ?></td>
                    <td><?php echo number_format($task['reward_amount'], 2); ?> SHIB</td>
                    <td><span class="status-btn <?php echo $task['status']; ?>"><?php echo ucfirst($task['status']); ?></span></td>
                    <td>
                        <form action="" method="POST" style="display:inline;">
                            <input type="hidden" name="task_id" value="<?php echo $task['id']; ?>">
                            <input type="hidden" name="current_status" value="<?php echo $task['status']; ?>">
                            <button type="submit" name="toggle_status" class="status-btn <?php echo ($task['status'] === 'active') ? 'inactive' : 'active'; ?>">
                                Toggle
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
<?php $conn->close(); ?>