<?php
// ফাইল: bot.php (সম্পূর্ণ এবং কার্যকরী)

require_once 'config.php';
$conn = require_once 'db.php';

// টেলিগ্রাম থেকে পাঠানো ডেটা গ্রহণ
$update = json_decode(file_get_contents("php://input"), TRUE);
if (!$update) {
    exit();
}

// --- বিভিন্ন ধরনের ইনপুট হ্যান্ডেল করার জন্য ---
$message = $update['message'] ?? null;
$callback_query = $update['callback_query'] ?? null;

// ১. নতুন মেসেজ বা কমান্ড হ্যান্ডেল করা
if ($message) {
    $chat_id = $message['chat']['id'] ?? null;
    $text = $message['text'] ?? '';
    $first_name = $message['from']['first_name'] ?? '';
    $username = $message['from']['username'] ?? null;

    // শুধু /start বা /start=... কমান্ডে কাজ করবে
    if ($chat_id && strpos($text, '/start') === 0) {
        
        // --- রেফারেল লজিক ---
        $referrer_id = null;
        $parts = explode(' ', $text);
        if (count($parts) > 1 && is_numeric($parts[1])) {
            $referrer_id = (int)$parts[1];
            if ($referrer_id == $chat_id) $referrer_id = null; // নিজেকে রেফার করা যাবে না
        }

        // ব্যবহারকারী ডাটাবেসে আছে কিনা চেক করা
        $stmt_check = $conn->prepare("SELECT id FROM users WHERE chat_id = ?");
        $stmt_check->bind_param('i', $chat_id);
        $stmt_check->execute();
        $is_new_user = ($stmt_check->get_result()->num_rows == 0);
        $stmt_check->close();

        // যদি ব্যবহারকারী নতুন হয় এবং রেফারার থাকে
        if ($is_new_user && $referrer_id) {
            $referral_bonus = 0.10; // রেফারেল বোনাস
            $stmt_referrer = $conn->prepare("UPDATE users SET total_balance = total_balance + ?, total_referrals = total_referrals + 1 WHERE chat_id = ?");
            $stmt_referrer->bind_param('di', $referral_bonus, $referrer_id);
            $stmt_referrer->execute();
            $stmt_referrer->close();

            // রেফারারকে নোটিফিকেশন পাঠানো
            $notification_message = "🎉 অভিনন্দন! আপনার রেফারে {$first_name} জয়েন করেছে এবং আপনি {$referral_bonus} SHIB বোনাস পেয়েছেন।";
            sendMessage($referrer_id, $notification_message);
        }

        // নতুন/পুরাতন ব্যবহারকারীর তথ্য ডাটাবেসে যোগ বা আপডেট করা
        $photo_url = getUserProfilePhotoUrl($chat_id, BOT_TOKEN);
        // আপনার বটের আসল ইউজারনেম দিন (t.me/ এর পরের অংশ)
        $bot_username_query = file_get_contents('https://api.telegram.org/bot' . BOT_TOKEN . '/getMe');
        $bot_info = json_decode($bot_username_query, true);
        $bot_username = $bot_info['result']['username'] ?? 'YourBotUsername';
        $referral_link = "https://t.me/{$bot_username}?start={$chat_id}";

        $stmt_user = $conn->prepare(
            "INSERT INTO users (chat_id, first_name, username, profile_photo_url, referrer_id, referral_link) 
             VALUES (?, ?, ?, ?, ?, ?)
             ON DUPLICATE KEY UPDATE 
             first_name = VALUES(first_name), 
             username = VALUES(username), 
             profile_photo_url = VALUES(profile_photo_url),
             referral_link = VALUES(referral_link)"
        );
        $final_referrer_id = $is_new_user ? $referrer_id : null;
        $stmt_user->bind_param('isssis', $chat_id, $first_name, $username, $photo_url, $final_referrer_id, $referral_link);
        $stmt_user->execute();
        $stmt_user->close();
        
        // স্বাগত বার্তা ও বাটন তৈরি
        $welcome_message = "স্বাগতম, {$first_name}! আপনার ড্যাশবোর্ড দেখতে নিচের বাটনে ক্লিক করুন।";
        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => '🚀 ড্যাশবোর্ড খুলুন', 'web_app' => ['url' => WEB_APP_URL . '/index.php?user_id=' . $chat_id]]
                ],
                [
                    ['text' => '🔗 আমার রেফারেল লিঙ্ক', 'callback_data' => 'get_referral_link']
                ]
            ]
        ];
        
        sendMessage($chat_id, $welcome_message, json_encode($keyboard));
    }
}

// ২. ইনলাইন বাটনের ক্লিক হ্যান্ডেল করা
if ($callback_query) {
    $callback_chat_id = $callback_query['from']['id'];
    $callback_data = $callback_query['data'];
    $callback_query_id = $callback_query['id'];

    if ($callback_data === 'get_referral_link') {
        $stmt_link = $conn->prepare("SELECT referral_link FROM users WHERE chat_id = ?");
        $stmt_link->bind_param('i', $callback_chat_id);
        $stmt_link->execute();
        $user_data = $stmt_link->get_result()->fetch_assoc();
        $stmt_link->close();

        if ($user_data && $user_data['referral_link']) {
            $link_message = "আপনার বন্ধুদের আমন্ত্রণ জানাতে নিচের লিঙ্কটি শেয়ার করুন:\n\n`{$user_data['referral_link']}`\n\nপ্রতি সফল রেফারের জন্য আপনি বোনাস পাবেন!";
            sendMessage($callback_chat_id, $link_message, null, 'Markdown');
        }
    }
    // ইনলাইন বাটনের লোডিং অ্যানিমেশন বন্ধ করা
    answerCallbackQuery($callback_query_id);
}


// --- হেল্পার ফাংশনগুলো ---

function sendMessage($chat_id, $text, $reply_markup = null, $parse_mode = 'HTML') {
    $url = 'https://api.telegram.org/bot' . BOT_TOKEN . '/sendMessage';
    $data = ['chat_id' => $chat_id, 'text' => $text, 'parse_mode' => $parse_mode];
    if ($reply_markup) {
        $data['reply_markup'] = $reply_markup;
    }
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

function getUserProfilePhotoUrl($chat_id, $token) {
    $url = "https://api.telegram.org/bot{$token}/getUserProfilePhotos?user_id={$chat_id}&limit=1";
    $response = json_decode(file_get_contents($url), true);
    if (isset($response['ok']) && $response['ok'] && !empty($response['result']['photos'])) {
        $file_id = $response['result']['photos'][0][0]['file_id'];
        $file_path_url = "https://api.telegram.org/bot{$token}/getFile?file_id={$file_id}";
        $file_path_response = json_decode(file_get_contents($file_path_url), true);
        if (isset($file_path_response['ok']) && $file_path_response['ok']) {
            return "https://api.telegram.org/file/bot{$token}/{$file_path_response['result']['file_path']}";
        }
    }
    return null;
}

function answerCallbackQuery($callback_query_id) {
    $url = 'https://api.telegram.org/bot' . BOT_TOKEN . '/answerCallbackQuery';
    $data = ['callback_query_id' => $callback_query_id];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

$conn->close();
?>