<?php
// ফাইল: db.php (স্বয়ংক্রিয় টেবিল ও কলাম তৈরি সহ)
require_once 'config.php';

// ডাটাবেস কানেকশন তৈরি
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// কানেকশন চেক
if ($conn->connect_error) {
    die("ডাটাবেস কানেকশন ব্যর্থ: " . $conn->connect_error);
}

// বাংলা ও ইমোজি সাপোর্টের জন্য UTF-8 সেট করা
$conn->set_charset("utf8mb4");


// --- স্বয়ংক্রিয় ডাটাবেস মাইগ্রেশন শুরু ---

function run_migration($conn, $sql, $message) {
    if (!$conn->query($sql)) {
        // যদি কোয়েরি চালাতে সমস্যা হয়, তাহলে এরর দেখাবে
        die("মাইগ্রেশন ব্যর্থ: {$message} - এরর: " . $conn->error);
    }
}

// ১. 'users' টেবিল চেক ও তৈরি করা
$usersTableSQL = "
CREATE TABLE IF NOT EXISTS `users` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `chat_id` BIGINT(20) NOT NULL UNIQUE,
  `first_name` VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` VARCHAR(255) DEFAULT NULL,
  `profile_photo_url` VARCHAR(255) DEFAULT NULL,
  `total_balance` DECIMAL(10, 2) DEFAULT 0.00,
  `total_referrals` INT(11) DEFAULT 0,
  `total_tasks_completed` INT(11) DEFAULT 0,
  `total_deposit` DECIMAL(10, 2) DEFAULT 0.00,
  `registered_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_seen` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
";
run_migration($conn, $usersTableSQL, "'users' টেবিল তৈরি");

// 'users' টেবিলে রেফারেল কলামগুলো চেক ও যোগ করা
$checkReferrerColumn = "SHOW COLUMNS FROM `users` LIKE 'referrer_id'";
if ($conn->query($checkReferrerColumn)->num_rows == 0) {
    $alterUsersTableSQL = "ALTER TABLE `users` 
        ADD COLUMN `referrer_id` BIGINT(20) DEFAULT NULL,
        ADD COLUMN `referral_link` VARCHAR(255) DEFAULT NULL;";
    run_migration($conn, $alterUsersTableSQL, "'users' টেবিলে রেফারেল কলাম যোগ");
}


// ২. 'tg_tasks' টেবিল চেক ও তৈরি করা
$tgTasksTableSQL = "
CREATE TABLE IF NOT EXISTS `tg_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_name` varchar(255) NOT NULL,
  `task_description` varchar(255) NOT NULL,
  `reward_amount` decimal(10,2) NOT NULL,
  `task_link` varchar(255) NOT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
";
run_migration($conn, $tgTasksTableSQL, "'tg_tasks' টেবিল তৈরি");


// ৩. 'user_tasks' টেবিল চেক ও তৈরি করা
$userTasksTableSQL = "
CREATE TABLE IF NOT EXISTS `user_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `task_id` int(11) NOT NULL,
  `completed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_task_unique` (`user_id`,`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
";
run_migration($conn, $userTasksTableSQL, "'user_tasks' টেবিল তৈরি");


// ৪. 'withdrawals' টেবিল চেক ও তৈরি করা
$withdrawalsTableSQL = "
CREATE TABLE IF NOT EXISTS `withdrawals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `method` varchar(50) NOT NULL,
  `account_number` varchar(50) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `status` enum('pending','completed','rejected') DEFAULT 'pending',
  `requested_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
";
run_migration($conn, $withdrawalsTableSQL, "'withdrawals' টেবিল তৈরি");


// --- নমুনা টাস্ক যোগ করা (যদি টেবিল খালি থাকে) ---
$checkTasks = $conn->query("SELECT id FROM tg_tasks LIMIT 1");
if ($checkTasks->num_rows == 0) {
    $insertSampleTasksSQL = "
    INSERT INTO `tg_tasks` (`task_name`, `task_description`, `reward_amount`, `task_link`) VALUES
    ('@vip_earnings_force', 'Join channel to earn', '10.00', 'https://t.me/vip_earnings_force'),
    ('@EarningOfficialBD1', 'Join channel to earn', '10.00', 'https://t.me/EarningOfficialBD1'),
    ('@Allearningsbd', 'Join channel to earn', '10.00', 'https://t.me/Allearningsbd'),
    ('@ultimateshibpayout', 'Join channel to earn', '40.00', 'https://t.me/ultimateshibpayout');
    ";
    run_migration($conn, $insertSampleTasksSQL, "নমুনা টাস্ক যোগ");
}

// --- স্বয়ংক্রিয় ডাটাবেস মাইগ্রেশন শেষ ---


// এই ফাইলটি $conn ভ্যারিয়েবলটি রিটার্ন করবে যাতে অন্য ফাইলগুলো এটি ব্যবহার করতে পারে
return $conn;
?>