<?php
// =================================================================
// GIGAPUB POSTBACK CALLBACK HANDLER
// =================================================================
require_once '../config.php';
$conn = require_once '../db.php';

// বট নোটিফিকেশন ফাংশন
function sendTelegramNotification($chat_id, $message) {
    if (!defined('BOT_TOKEN') || empty(BOT_TOKEN)) return;
    $bot_token = BOT_TOKEN;
    $url = "https://api.telegram.org/bot{$bot_token}/sendMessage?chat_id={$chat_id}&text=".urlencode($message)."&parse_mode=HTML";
    @file_get_contents($url);
}

// Gigapub থেকে পাঠানো প্যারামিটারগুলো গ্রহণ করা
$user_id = $_GET['user_id'] ?? null; // এটি হলো chat_id
$transaction_id = $_GET['transaction_id'] ?? null;
$offer_id = $_GET['offer_id'] ?? null;

// security hash ভেরিফিকেশন (ডকুমেন্টেশন অনুযায়ী)
$project_id_from_db = $conn->query("SELECT setting_value FROM settings WHERE setting_key = 'gigapub_project_id'")->fetch_assoc()['setting_value'];
$hash = $_GET['hash'] ?? null;
$expected_hash = md5($transaction_id . $project_id_from_db);

if ($hash !== $expected_hash) {
    // যদি হ্যাশ না মেলে, তাহলে রিকোয়েস্টটি ভুয়া
    http_response_code(400); // Bad Request
    echo "NOK";
    exit();
}

// চ্যাট আইডি এবং অন্যান্য ডেটা ভ্যালিড কিনা তা চেক করা
if ($user_id && $transaction_id && $offer_id) {
    // অ্যাডমিন প্যানেল থেকে সেট করা রিওয়ার্ডের পরিমাণ আনা
    $reward_per_task = $conn->query("SELECT setting_value FROM settings WHERE setting_key = 'gigapub_reward_per_task'")->fetch_assoc()['setting_value'];
    
    // ব্যবহারকারীর ব্যালেন্স আপডেট করা
    // gigapub_tasks_done কলামটি users টেবিলে থাকতে হবে
    $stmt = $conn->prepare("UPDATE users SET total_balance = total_balance + ?, gigapub_tasks_done = gigapub_tasks_done + 1 WHERE chat_id = ?");
    $stmt->bind_param('di', $reward_per_task, $user_id);

    if ($stmt->execute()) {
        // ব্যবহারকারীকে নোটিফিকেশন পাঠানো
        $message = "🎉 Congratulations!\n\nYou have successfully completed a Gigapub task and earned {$reward_per_task} BDT.";
        sendTelegramNotification($user_id, $message);
        
        // Gigapub-কে সফলতার সিগন্যাল পাঠানো
        http_response_code(200);
        echo "OK";
    } else {
        // ডাটাবেস আপডেটে সমস্যা হলে
        http_response_code(500); // Internal Server Error
        echo "NOK";
    }
} else {
    // প্রয়োজনীয় প্যারামিটার না পাওয়া গেলে
    http_response_code(400);
    echo "NOK";
}

$conn->close();
?>