<?php
session_start();
// সরাসরি এই ফাইল অ্যাক্সেস বন্ধ করার জন্য একটি নিরাপত্তা ব্যবস্থা
if (!defined('IS_VALID_PAGE')) {
    die('Invalid access');
}

require_once '../config.php';
$conn = require_once '../db.php';

$user_id = filter_input(INPUT_GET, 'user_id', FILTER_SANITIZE_NUMBER_INT);
if (!$user_id) {
    die("সঠিক ব্যবহারকারী আইডি পাওয়া যায়নি।");
}

$stmt = $conn->prepare("SELECT * FROM users WHERE chat_id = ?");
$stmt->bind_param('i', $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
if (!$user) {
    die("ব্যবহারকারীকে খুঁজে পাওয়া যায়নি।");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title><?php echo htmlspecialchars($page_title ?? 'Dashboard'); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://telegram.org/js/telegram-web-app.js"></script>
    
    <style>
        :root {
            --primary-color: #4A90E2; --secondary-color: #50E3C2; --bg-dark: #161922;
            --bg-card: #252836; --text-light: #FFFFFF; --text-muted: #9A9A9A;
        }
        body { margin: 0; font-family: 'Poppins', sans-serif; background-color: var(--bg-dark); color: var(--text-light); padding: 20px 20px 95px 20px; }
        a { text-decoration: none; color: inherit; }
        
        /* ড্যাশবোর্ড স্টাইল */
        .home-header { display: flex; justify-content: space-between; align-items: center; padding-bottom: 20px; }
        .greeting p { margin: 0; color: var(--text-muted); } .greeting h2 { margin: 4px 0 0; }
        .profile-pic img { width: 45px; height: 45px; border-radius: 50%; }
        .balance-display { text-align: center; margin: 10px 0; } .balance-display h1 { font-size: 3em; margin: 8px 0; letter-spacing: 1px; }
        .virtual-card-container { perspective: 1000px; }
        .virtual-card { background: linear-gradient(135deg, #2D3142, #1C1E26); border-radius: 20px; padding: 25px; margin-top: 20px; box-shadow: 0 15px 35px rgba(0,0,0,0.3); border: 1px solid rgba(255,255,255,0.1); position: relative; }
        .card-top { display: flex; justify-content: space-between; align-items: center; } .card-chip { width: 40px; height: 30px; background: #FFD700; border-radius: 5px; } .card-logo { font-size: 24px; font-weight: bold; }
        .card-number { font-size: 1.6em; letter-spacing: 3px; margin: 25px 0; text-align: center; }
        .card-details { display: flex; justify-content: space-between; } .card-details p { color: var(--text-muted); margin: 0; font-size: 0.8em; } .card-details span { font-weight: 500; }
        .action-buttons { display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; margin: 30px 0; text-align: center; }
        .action-btn { width: 60px; height: 60px; background: linear-gradient(135deg, #00c6ff, #0072ff); color: white; border-radius: 50%; display: flex; justify-content: center; align-items: center; font-size: 26px; box-shadow: 0 8px 16px rgba(0, 0, 0, 0.25); cursor: pointer; transition: transform 0.3s ease, box-shadow 0.3s ease; position: relative; overflow: hidden; margin: 0 auto; }
        .action-btn::after { content: ''; position: absolute; width: 200%; height: 200%; background: rgba(255, 255, 255, 0.1); top: -100%; left: -100%; transform: rotate(45deg); transition: 0.4s ease-in-out; }
        .action-btn:hover::after { top: 100%; left: 100%; } .action-btn:hover { transform: scale(1.1); box-shadow: 0 10px 20px rgba(0, 0, 0, 0.35); }
        .action-btn-label { font-size: 0.8em; margin-top: 15px; }
        .contact-list { display: flex; gap: 20px; margin-top: 20px; overflow-x: auto; padding-bottom: 10px; } .contact-item { text-align: center; } .contact-item img { width: 60px; height: 60px; border-radius: 50%; } .contact-item p { margin-top: 8px; font-size: 0.9em; }

        /* অন্যান্য পেজের জন্য কমন স্টাইল */
        .page-header { display: flex; align-items: center; margin-bottom: 25px; position: relative; text-align: center; }
        .back-btn { font-size: 24px; color: var(--text-light); position: absolute; left: 0; }
        .page-header h2 { margin: 0 auto; font-size: 1.4em; }
        .content-box { background-color: var(--bg-card); padding: 20px; border-radius: 15px; }

        /* ফুটার */
        footer { position: fixed; bottom: 0; left: 0; right: 0; background: var(--bg-card); display: flex; justify-content: space-around; align-items: center; padding: 10px 0; border-top-left-radius: 25px; border-top-right-radius: 25px; box-shadow: 0 -5px 20px rgba(0,0,0,0.2); }
        footer a { color: var(--text-muted); text-decoration: none; font-size: 24px; }
        footer a.active { color: var(--secondary-color); }
        .nav-item-main { background: var(--secondary-color); color: var(--bg-dark); width: 60px; height: 60px; border-radius: 50%; display: flex; justify-content: center; align-items: center; transform: translateY(-25px); border: 5px solid var(--bg-dark); }
    </style>
</head>
<body>
    <div class="page-container">