<?php
// =================================================================
// ALL-IN-ONE TELEGRAM WEB APP (Dark Theme Dashboard) - সংশোধিত সংস্করণ
// =================================================================
session_start();
require_once '../config.php';
$conn = require_once '../db.php';

// --- API রিকোয়েস্ট হ্যান্ডেলিং (অপরিবর্তিত) ---
if (isset($_POST['action'])) {
    header('Content-Type: application/json');
    $action = $_POST['action'];
    $response = ['success' => false, 'message' => 'Invalid action.'];
    // ... আপনার API লজিক এখানে থাকবে ...
    echo json_encode($response);
    $conn->close();
    exit();
}

// --- ওয়েব অ্যাপের মূল অংশ (অপরিবর্তিত) ---
$user_id = filter_input(INPUT_GET, 'user_id', FILTER_SANITIZE_NUMBER_INT);
if (!$user_id) die("সঠিক ব্যবহারকারী আইডি পাওয়া যায়নি।");

$stmt = $conn->prepare("SELECT * FROM users WHERE chat_id = ?");
$stmt->bind_param('i', $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
if (!$user) die("ব্যবহারকারীকে খুঁজে পাওয়া যায়নি।");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title>Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://telegram.org/js/telegram-web-app.js"></script>
    
    <!-- ======================= CSS কোড (অপরিবর্তিত) ======================= -->
    <style>
        :root {
            --primary-color: #4A90E2;
            --secondary-color: #50E3C2;
            --bg-dark: #161922;
            --bg-card: #252836;
            --text-light: #FFFFFF;
            --text-muted: #9A9A9A;
        }
        body {
            margin: 0;
            font-family: 'Poppins', sans-serif;
            background-color: var(--bg-dark);
            color: var(--text-light);
            padding: 20px 20px 95px 20px; /* ফুটারের জন্য জায়গা রাখতে padding-bottom বাড়ানো হয়েছে */
        }
        a {
            text-decoration: none;
            color: inherit;
        }

        /* হেডার */
        .home-header { display: flex; justify-content: space-between; align-items: center; }
        .greeting p { margin: 0; color: var(--text-muted); }
        .greeting h2 { margin: 4px 0 0; }
        .profile-pic img { width: 45px; height: 45px; border-radius: 50%; cursor: pointer; }

        /* ব্যালেন্স */
        .balance-display { text-align: center; margin: 10px 0; }
        .balance-display p { color: var(--text-muted); }
        .balance-display h1 { font-size: 3em; margin: 8px 0; letter-spacing: 1px; }

        /* ভার্চুয়াল কার্ড */
        .virtual-card-container { perspective: 1000px; }
        .virtual-card {
            background: linear-gradient(135deg, #2D3142, #1C1E26);
            border-radius: 20px; padding: 25px; margin-top: 20px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.3);
            border: 1px solid rgba(255,255,255,0.1);
            position: relative;
        }
        .card-top { display: flex; justify-content: space-between; align-items: center; }
        .card-chip { width: 40px; height: 30px; background: #FFD700; border-radius: 5px; }
        .card-logo { font-size: 24px; font-weight: bold; }
        .card-number { font-size: 1.6em; letter-spacing: 3px; margin: 25px 0; text-align: center; }
        .card-details { display: flex; justify-content: space-between; }
        .card-details p { color: var(--text-muted); margin: 0; font-size: 0.8em; }
        .card-details span { font-weight: 500; }
        
        /* অ্যাকশন বাটন */
        .action-buttons { display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; margin: 30px 0; text-align: center; }
        /* ▼▼▼ ডিজাইনের জন্য action-btn এখন সরাসরি <a> ট্যাগে ব্যবহার হবে ▼▼▼ */
        .action-btn {
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0 auto; /* বাটনকে মাঝখানে আনতে */
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #00c6ff, #0072ff);
            color: white;
            border-radius: 50%;
            font-size: 26px;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.25);
            cursor: pointer;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        .action-btn::after { content: ''; position: absolute; width: 200%; height: 200%; background: rgba(255, 255, 255, 0.1); top: -100%; left: -100%; transform: rotate(45deg); transition: 0.4s ease-in-out; }
        .action-btn:hover::after { top: 100%; left: 100%; }
        .action-btn:hover { transform: scale(1.1); box-shadow: 0 10px 20px rgba(0, 0, 0, 0.35); }
        .action-btn-label { font-size: 0.8em; margin-top: 15px; text-align: center; }

        /* Send Money / Task Section */
        .section-header { display: flex; justify-content: space-between; align-items: center; margin-top: 30px; }
        .section-title { font-size: 1.2em; font-weight: 600; }
        .contact-list-btn { color: var(--text-muted); text-decoration: none; font-size: 0.9em; }
        .contact-list { display: flex; gap: 20px; margin-top: 20px; overflow-x: auto; padding-bottom: 10px; }
        .contact-item { text-align: center; }
        .contact-item img { width: 60px; height: 60px; border-radius: 50%; }
        .contact-item p { margin-top: 8px; font-size: 0.9em; }

        /* ফুটার */
        footer {
            position: fixed; bottom: 0; left: 0; right: 0; background: var(--bg-card);
            display: flex; justify-content: space-around; align-items: center;
            padding: 10px 0; border-top-left-radius: 25px; border-top-right-radius: 25px;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.2);
        }
        footer a { color: var(--text-muted); text-decoration: none; font-size: 24px; }
        footer a.active { color: var(--secondary-color); } /* হোমপেজের জন্য active ক্লাস */
        .nav-item-main {
            background: var(--secondary-color); color: var(--bg-dark); width: 60px; height: 60px;
            border-radius: 50%; display: flex; justify-content: center; align-items: center;
            transform: translateY(-25px); border: 5px solid var(--bg-dark);
        }
    </style>
</head>
<body>
    <!-- FontAwesome আইকন লোড করার জন্য (ঐচ্ছিক) -->
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

    <!-- ======================= HTML কন্টেন্ট ======================= -->
    
    <div class="main-container">
        <!-- ▼▼▼ Profile Picture লিঙ্ক পরিবর্তন করা হয়েছে ▼▼▼ -->
        <header class="home-header">
            <div class="greeting"><p>Hello ,</p><h2><?php echo htmlspecialchars($user['first_name']); ?></h2></div>
            <div class="profile-pic">
                <a href="profile.php?user_id=<?php echo $user_id; ?>">
                    <img src="<?php echo htmlspecialchars($user['profile_photo_url'] ?? 'assets/default_avatar.png'); ?>">
                </a>
            </div>
        </header>
        
        <div class="balance-display"><p>Total Balance</p><h1>$<?php echo number_format($user['total_balance'], 2); ?></h1></div>

        <div class="virtual-card-container">
            <div class="virtual-card">
                <div class="card-top"><div class="card-chip"></div><div class="card-logo">VISA</div></div>
                <div class="card-number">5245 5634 1094 </div>
                <div class="card-details">
                    <div><p>Card Holder</p><span><?php echo htmlspecialchars($user['first_name']); ?></span></div>
                    <div><p>Expires</p><span>12/26</span></div>
                </div>
            </div>
        </div>
        
        <!-- ▼▼▼ Action Buttons এর লিঙ্কগুলো পরিবর্তন করা হয়েছে ▼▼▼ -->
        <div class="action-buttons">
            <div>
                <a href="monetag.php?user_id=<?php echo $user_id; ?>" class="action-btn">⬆️</a>
                <p class="action-btn-label">monetag</p>
            </div>
            <div>
                <a href="adsterra.php?user_id=<?php echo $user_id; ?>" class="action-btn">⬇️</a>
                <p class="action-btn-label">adsterra</p>
            </div>
            <div>
                <a href="gigapub.php?user_id=<?php echo $user_id; ?>" class="action-btn">📄</a>
                <p class="action-btn-label">gigapub</p>
            </div>
            <div>
                <a href="telegram.php?user_id=<?php echo $user_id; ?>" class="action-btn">➕</a>
                <p class="action-btn-label">telegram</p>
            </div>
        </div>

        <div class="section-header"><h3 class="section-title">Network</h3><a href="https://t.me/psupdateLAB" class="contact-list-btn">Developer</a></div>
        <div class="contact-list">
            <div class="contact-item"><img src="assets/monetag.png"><p>monetag</p></div>
            <div class="contact-item"><img src="assets/adsterra.png"><p>adsterra</p></div>
            <div class="contact-item"><img src="assets/gigapub.jpeg"><p>gigapub</p></div>
            <div class="contact-item"><img src="assets/telegram.jpeg"><p>telegram</p></div>
        </div>
    </div>

    <!-- অপ্রয়োজনীয় পেজের div গুলো মুছে দেওয়া হয়েছে -->

    <!-- ======================= ফুটার (লিঙ্কসহ আপডেট করা) ======================= -->
    <footer>
        <a href="index.php?user_id=<?php echo $user_id; ?>" class="active">🏠</a>
        <a href="wallet.php?user_id=<?php echo $user_id; ?>">💼</a>
        <a href="refer.php?user_id=<?php echo $user_id; ?>" class="nav-item-main">⇄</a>
        <a href="profile.php?user_id=<?php echo $user_id; ?>">👤</a>
        <a href="settings.php?user_id=<?php echo $user_id; ?>">⚙️</a>
    </footer>

    <!-- ======================= JavaScript কোড (অপ্রয়োজনীয় navigateTo ফাংশন মুছে দেওয়া হয়েছে) ======================= -->
    <script>
        const tg = window.Telegram.WebApp;
        tg.ready();
        tg.expand();
        tg.setHeaderColor('#161922');

        // 3D কার্ড ইফেক্ট (অপরিবর্তিত)
        const card = document.querySelector('.virtual-card');
        document.querySelector('.virtual-card-container').addEventListener('mousemove', (e) => {
            let xAxis = (window.innerWidth / 2 - e.pageX) / 25;
            let yAxis = (window.innerHeight / 2 - e.pageY) / 25;
            card.style.transform = `rotateY(${xAxis}deg) rotateX(${yAxis}deg)`;
        });
        document.querySelector('.virtual-card-container').addEventListener('mouseleave', e => {
            card.style.transform = `rotateY(0deg) rotateX(0deg)`;
        });
    </script>
</body>
</html>
<?php
$conn->close();
?>