<?php

define('IS_VALID_PAGE', true);
$page_title = 'Monetag Tasks';
$current_page = 'home'; // ফুটার মেনুর জন্য
require_once 'includes/header.php'; 
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>MoneTag</title>
    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- Google Fonts for Bengali font -->
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&display=swap" rel="stylesheet">
    
    <style>
        /* CSS Property for smooth angle animation */
        @property --angle {
          syntax: "<angle>";
          initial-value: 0deg;
          inherits: false;
        }

        @keyframes spin {
          to {
            --angle: 360deg;
          }
        }

        body {
            margin: 0;
            font-family: 'Hind Siliguri', sans-serif;
            background-color: #0d1b2a; /* Dark blue background from screenshot */
            color: #ffffff;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }

        .app-container {
            flex-grow: 1;
            padding: 15px;
            display: flex;
            flex-direction: column;
            max-width: 400px; /* Limit width on larger screens */
            margin: 0 auto;
            width: 100%;
            box-sizing: border-box;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding-top: 10px; /* Space for status bar */
        }

        .header-title {
            font-size: 22px;
            font-weight: 600;
        }

        .header i {
            font-size: 20px;
            color: #e0e1dd;
            cursor: pointer;
        }

        .brand-section {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 25px;
        }

        .brand-logo {
            width: 45px;
            height: 45px;
            background-color: #ffc300; /* Yellow logo background */
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .brand-logo i {
            color: #0d1b2a;
            font-size: 20px;
        }

        .brand-info h1 {
            margin: 0;
            font-size: 26px;
            color: #00aaff; /* Bright blue for MoneTag */
            font-weight: 700;
            line-height: 1.1;
        }

        .brand-info p {
            margin: 0;
            font-size: 14px;
            color: #b0c4de;
        }

        /* --- ANIMATED BORDER STYLES START --- */
        .balance-card,
        .stat-box {
            position: relative;
            background-clip: padding-box; /* Ensures background doesn't go under the border */
            border: 2px solid transparent;
        }

        .balance-card::before,
        .stat-box::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            margin: -2px; /* Controls the border thickness */
            background: conic-gradient(
                from var(--angle),
                #00aaff, #ff2dff, #39ff14, #ffc300, #00aaff
            );
            animation: spin 3s linear infinite;
            z-index: -1;
        }
        
        .balance-card::before { border-radius: 22px; }
        .stat-box::before { border-radius: 17px; }
        /* --- ANIMATED BORDER STYLES END --- */


        .balance-card {
            background-color: #1e3a8a; /* Solid color to cover the gradient behind */
            border-radius: 20px;
            padding: 25px;
            text-align: center;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.25);
            margin-bottom: 20px;
        }

        .balance-card .title {
            font-size: 16px;
            color: #b0c4de;
            margin: 0 0 5px 0;
        }

        .balance-card .amount {
            font-size: 48px;
            font-weight: 700;
            margin: 0 0 15px 0;
            line-height: 1.2;
        }

        .balance-card .per-ad-income {
            background-color: rgba(0, 0, 0, 0.2);
            display: inline-block;
            padding: 6px 15px;
            border-radius: 15px;
            font-size: 13px;
        }

        .stats-container {
            display: flex;
            gap: 15px;
            margin-bottom: 20px;
        }

        .stat-box {
            flex: 1;
            background-color: #1c2a4a; /* Darker box color */
            border-radius: 15px;
            padding: 20px;
            text-align: center;
        }

        .stat-box .icon {
            font-size: 24px;
            color: #00aaff;
            margin-bottom: 10px;
        }
        
        .stat-box .label {
            font-size: 14px;
            color: #b0c4de;
            margin: 0 0 5px 0;
        }
        
        .stat-box .value {
            font-size: 24px;
            font-weight: 600;
            margin: 0;
        }

        /* --- UPDATED BUTTON CONTAINER STYLE --- */
        .action-button-container {
            margin-top: 30px; /* স্পেস তৈরি করার জন্য margin-top যোগ করা হয়েছে */
            padding-bottom: 20px; /* নিচে কিছুটা অতিরিক্ত স্পেস */
        }
        
        .action-button {
            width: 100%;
            padding: 16px;
            background-color: #00aaff;
            color: #ffffff;
            border: none;
            border-radius: 15px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            transition: background-color 0.3s, transform 0.2s;
        }

        .action-button:active {
            transform: scale(0.98);
            background-color: #0088cc;
        }
        /* ফুটার */
        footer {
            position: fixed; bottom: 0; left: 0; right: 0; background: var(--bg-card);
            display: flex; justify-content: space-around; align-items: center;
            padding: 10px 0; border-top-left-radius: 25px; border-top-right-radius: 25px;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.2);
        }
        footer a { color: var(--text-muted); text-decoration: none; font-size: 24px; }
        footer a.active { color: var(--secondary-color); } /* হোমপেজের জন্য active ক্লাস */
        .nav-item-main {
            background: var(--secondary-color); color: var(--bg-dark); width: 60px; height: 60px;
            border-radius: 50%; display: flex; justify-content: center; align-items: center;
            transform: translateY(-25px); border: 5px solid var(--bg-dark);
        }
    </style>
</head>
<body>

    <div class="app-container">
        <!-- Header -->
        
        <!-- Brand Section -->
        <div class="brand-section">
            <div class="brand-logo">
                <i class="fas fa-play"></i>
            </div>
            <div class="brand-info">
                <h1>MoneTag</h1>
                <p>বিজ্ঞাপন দেখুন, অর্থ উপার্জন করুন</p>
            </div>
        </div>

        <!-- Balance Card -->
        <div class="balance-card">
            <p class="title">আপনার ব্যালেন্স</p>
            <h2 class="amount" id="balance-amount">৳০.০০</h2>
            <div class="per-ad-income">প্রতি বিজ্ঞাপনে আয়: ৳০.০০৪</div>
        </div>

        <!-- Stats Container -->
        <div class="stats-container">
            <div class="stat-box">
                <div class="icon"><i class="fas fa-desktop"></i></div>
                <p class="label">মোট বিজ্ঞাপন</p>
                <p class="value" id="total-ads">0</p>
            </div>
            <div class="stat-box">
                <div class="icon"><i class="fas fa-coins"></i></div>
                <p class="label">মোট আয়</p>
                <p class="value" id="total-income">৳০.০০</p>
            </div>
        </div>

        <!-- Action Button -->
        <div class="action-button-container">
            <button class="action-button" onclick="showRewardedAd()">
                <i class="fas fa-play"></i>
                বিজ্ঞাপন দেখুন
            </button>
        </div>

    <!-- ======================= ফুটার (লিঙ্কসহ আপডেট করা) ======================= -->
    <footer>
        <a href="index.php?user_id=<?php echo $user_id; ?>" class="active">🏠</a>
        <a href="wallet.php?user_id=<?php echo $user_id; ?>">💼</a>
        <a href="refer.php?user_id=<?php echo $user_id; ?>" class="nav-item-main">⇄</a>
        <a href="profile.php?user_id=<?php echo $user_id; ?>">👤</a>
        <a href="settings.php?user_id=<?php echo $user_id; ?>">⚙️</a>
    </footer>
    
    
    
    </div>

    <!-- আপনার দেওয়া Ad SDK Script -->
    <script src="//libtl.com/sdk.js" data-zone="9669999" data-sdk="show_9669999"></script>

    <script>
        // DOM Elements
        const balanceEl = document.getElementById('balance-amount');
        const totalAdsEl = document.getElementById('total-ads');
        const totalIncomeEl = document.getElementById('total-income');

        // Initial Values from localStorage or set to 0
        let rewardCount = parseInt(localStorage.getItem('monetag_ad_count')) || 0;
        let balance = parseFloat(localStorage.getItem('monetag_balance')) || 0.0;
        const rewardAmount = 0.004; // প্রতি বিজ্ঞাপনে আয়

        // Function to update the UI
        function updateUI() {
            balanceEl.textContent = `৳${balance.toFixed(2)}`;
            totalAdsEl.textContent = rewardCount;
            totalIncomeEl.textContent = `৳${balance.toFixed(2)}`; // মোট আয় এবং ব্যালেন্স একই
        }

        // Function to show ad and handle reward
        function showRewardedAd() {
            if (typeof show_9669999 === 'function') {
                show_9669999().then(() => {
                    console.log("Ad watched successfully! Awarding reward.");

                    rewardCount += 1;
                    balance += rewardAmount;

                    localStorage.setItem('monetag_ad_count', rewardCount);
                    localStorage.setItem('monetag_balance', balance.toFixed(4));

                    updateUI();

                }).catch(error => {
                    console.error('Ad failed to load or was closed by the user:', error);
                });
            } else {
                console.error('Ad script (show_9669999) is not available.');
                alert('বিজ্ঞাপন লোড হতে সমস্যা হচ্ছে। অনুগ্রহ করে পৃষ্ঠাটি রিলোড করুন।');
            }
        }

        document.addEventListener('DOMContentLoaded', () => {
            updateUI();
        });
    </script>
</body>
</html>