<?php
// =================================================================
// PROFILE PAGE (Inspired by your design)
// =================================================================
session_start();
require_once '../config.php';
$conn = require_once '../db.php';

// URL থেকে user_id গ্রহণ করা
$user_id = filter_input(INPUT_GET, 'user_id', FILTER_SANITIZE_NUMBER_INT);
if (!$user_id) {
    die("সঠিক ব্যবহারকারী আইডি পাওয়া যায়নি।");
}

// ডাটাবেস থেকে ব্যবহারকারীর তথ্য আনা
$stmt = $conn->prepare("SELECT * FROM users WHERE chat_id = ?");
$stmt->bind_param('i', $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
if (!$user) {
    die("ব্যবহারকারীকে খুঁজে পাওয়া যায়নি।");
}

// ডেভেলপার কন্টাক্ট লিঙ্ক
$developer_telegram_link = "https://t.me/psupdateLAB"; // 📍📍📍 আপনার ডেভেলপারের টেলিগ্রাম ইউজারনেম দিন
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title>My Profile</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://telegram.org/js/telegram-web-app.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>

    <style>
        :root {
            --background-light: #F4F6F9;
            --white: #FFFFFF;
            --text-dark: #1E2022;
            --text-muted: #6A737D;
            --stat-blue-bg: #EBF5FF;      --stat-blue-icon: #007BFF;
            --stat-green-bg: #E8F5E9;     --stat-green-icon: #4CAF50;
            --stat-purple-bg: #F3E5F5;    --stat-purple-icon: #9C27B0;
            --stat-yellow-bg: #FFF3E0;    --stat-yellow-icon: #FF9800;

            /* ফুটারের জন্য ডার্ক থিম ভ্যারিয়েবল */
            --bg-dark: #161922;
            --bg-card: #252836;
            --secondary-color: #50E3C2;
        }

        body {
            margin: 0;
            font-family: 'Poppins', sans-serif;
            background-color: var(--background-light);
            color: var(--text-dark);
            padding: 15px;
            padding-bottom: 95px; /* ফুটারের জন্য জায়গা */
        }
        a { text-decoration: none; color: inherit; }

        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .close-btn { font-size: 14px; font-weight: 500; color: var(--text-muted); background-color: #e9ecef; padding: 8px 15px; border-radius: 20px; }
        .user-info { display: flex; align-items: center; }
        .user-info img { width: 40px; height: 40px; border-radius: 50%; margin-right: 10px; }
        .user-info .name { font-weight: 600; }
        .user-info .balance { font-size: 0.9em; color: var(--text-muted); }

        .card { background: var(--white); border-radius: 20px; padding: 20px; margin-bottom: 20px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); }
        
        .profile-main { text-align: center; }
        .profile-main img { width: 80px; height: 80px; border-radius: 50%; border: 3px solid #e0e0e0; }
        .profile-main .name { font-size: 1.4em; font-weight: 600; margin: 10px 0 5px 0; }
        .profile-main .joined-date { color: var(--text-muted); font-size: 0.9em; }

        .stats-title { font-weight: 600; margin-bottom: 15px; }
        .stats-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }
        .stat-box { padding: 15px; border-radius: 15px; }
        .stat-box .icon { font-size: 1.2em; margin-bottom: 8px; }
        .stat-box .label { font-size: 0.9em; color: var(--text-muted); }
        .stat-box .value { font-size: 1.5em; font-weight: 700; margin-top: 5px; }
        .stat-box.blue { background-color: var(--stat-blue-bg); color: var(--stat-blue-icon); }
        .stat-box.green { background-color: var(--stat-green-bg); color: var(--stat-green-icon); }
        .stat-box.purple { background-color: var(--stat-purple-bg); color: var(--stat-purple-icon); }
        .stat-box.yellow { background-color: var(--stat-yellow-bg); color: var(--stat-yellow-icon); }
        
        .action-links a {
            display: flex;
            align-items: center;
            padding: 15px;
            background: var(--white);
            border-radius: 12px;
            margin-bottom: 10px;
            font-weight: 500;
        }
        .action-links a:last-child { margin-bottom: 0; }
        .action-links .icon {
            width: 20px;
            text-align: center;
            margin-right: 15px;
            color: var(--text-muted);
            font-size: 1.1em;
        }
        .action-links .logout .icon { color: #dc3545; }

        /* আপনার index.php থেকে আনা ফুটার স্টাইল */
        footer { position: fixed; bottom: 0; left: 0; right: 0; background: var(--bg-card); display: flex; justify-content: space-around; align-items: center; padding: 10px 0; border-top-left-radius: 25px; border-top-right-radius: 25px; box-shadow: 0 -5px 20px rgba(0,0,0,0.2); }
        footer a { color: var(--text-muted); text-decoration: none; font-size: 24px; }
        footer a.active { color: var(--secondary-color); }
        .nav-item-main { background: var(--secondary-color); color: var(--bg-dark); width: 60px; height: 60px; border-radius: 50%; display: flex; justify-content: center; align-items: center; transform: translateY(-25px); border: 5px solid var(--bg-dark); }
    </style>
</head>
<body>

    <div class="header">
        <a href="index.php?user_id=<?php echo $user_id; ?>" class="close-btn"><i class="fas fa-times"></i> Close</a>
        <div class="user-info">
            <img src="<?php echo htmlspecialchars($user['profile_photo_url'] ?? 'assets/default_avatar.png'); ?>" alt="Profile">
            <div>
                <div class="name"><?php echo htmlspecialchars($user['first_name']); ?></div>
                <div class="balance">Balance: <?php echo number_format($user['total_balance'], 2); ?> SHIB</div>
            </div>
        </div>
    </div>

    <div class="card profile-main">
        <img src="<?php echo htmlspecialchars($user['profile_photo_url'] ?? 'assets/default_avatar.png'); ?>" alt="Profile">
        <h2 class="name"><?php echo htmlspecialchars($user['first_name']); ?></h2>
        <p class="joined-date">Joined <?php echo date("F j, Y", strtotime($user['created_at'])); ?></p>
    </div>

    <div class="card">
        <h3 class="stats-title">Your Statistics</h3>
        <div class="stats-grid">
            <div class="stat-box blue">
                <div class="icon"><i class="fas fa-coins"></i></div>
                <div class="label">Total Earned</div>
                <div class="value"><?php echo number_format($user['total_earned'] ?? 0); ?> SHIB</div>
            </div>
            <div class="stat-box green">
                <div class="icon"><i class="fas fa-check-circle"></i></div>
                <div class="label">Tasks Done</div>
                <div class="value"><?php echo (int)($user['tasks_done'] ?? 0); ?></div>
            </div>
            <div class="stat-box purple">
                <div class="icon"><i class="fas fa-calendar-check"></i></div>
                <div class="label">Current Streak</div>
                <div class="value"><?php echo (int)($user['current_streak'] ?? 0); ?> days</div>
            </div>
            <div class="stat-box yellow">
                <div class="icon"><i class="fas fa-users"></i></div>
                <div class="label">Referrals</div>
                <div class="value"><?php echo (int)($user['total_referrals'] ?? 0); ?></div>
            </div>
        </div>
    </div>

    <div class="action-links">
        <a href="#"><i class="fas fa-question-circle icon"></i> Help Center</a>
        <a href="<?php echo $developer_telegram_link; ?>"><i class="fab fa-telegram-plane icon"></i> Developer Contact</a>
        <a href="#" class="logout" onclick="confirmLogout()"><i class="fas fa-sign-out-alt icon"></i> Log Out</a>
    </div>

    <!-- আপনার ডার্ক থিমের ফুটার -->
    <footer>
        <a href="index.php?user_id=<?php echo $user_id; ?>">🏠</a>
        <a href="wallet.php?user_id=<?php echo $user_id; ?>">💼</a>
        <a href="refer.php?user_id=<?php echo $user_id; ?>" class="nav-item-main">⇄</a>
        <a href="profile.php?user_id=<?php echo $user_id; ?>" class="active">👤</a>
        <a href="settings.php?user_id=<?php echo $user_id; ?>">⚙️</a>
    </footer>

    <script>
        const tg = window.Telegram.WebApp;
        tg.ready();
        
        // হেডার রঙ পরিবর্তন করা হচ্ছে কারণ এই পেজের ব্যাকগ্রাউন্ড হালকা
        tg.setHeaderColor('#F4F6F9');

        function confirmLogout() {
            tg.showConfirm("Are you sure you want to log out?", function(isConfirmed) {
                if (isConfirmed) {
                    // এখানে লগ-আউটের আসল কোড থাকবে
                    // আপাতত, আমরা শুধু অ্যাপটি বন্ধ করে দিচ্ছি
                    tg.showAlert("You have been logged out.");
                    tg.close();
                }
            });
        }
    </script>
</body>
</html>
<?php
$conn->close();
?>