<?php
// =================================================================
// REFER & EARN PAGE (Inspired by your design)
// =================================================================
session_start();
require_once '../config.php';
$conn = require_once '../db.php';

// URL থেকে user_id গ্রহণ করা
$user_id = filter_input(INPUT_GET, 'user_id', FILTER_SANITIZE_NUMBER_INT);
if (!$user_id) {
    die("সঠিক ব্যবহারকারী আইডি পাওয়া যায়নি।");
}

// ডাটাবেস থেকে ব্যবহারকারীর তথ্য আনা
$stmt = $conn->prepare("SELECT * FROM users WHERE chat_id = ?");
$stmt->bind_param('i', $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
if (!$user) {
    die("ব্যবহারকারীকে খুঁজে পাওয়া যায়নি।");
}

// রেফারেল লিঙ্ক তৈরি (আপনার বটের ইউজারনেম দিন)
$bot_username = "shakilvi_bot"; // আপনার ছবির লিঙ্ক থেকে নেওয়া হয়েছে, প্রয়োজনে পরিবর্তন করুন
$referral_link = "https://t.me/{$bot_username}?start={$user['chat_id']}";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title>Refer & Earn</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://telegram.org/js/telegram-web-app.js"></script>
    <!-- Font Awesome Icons for buttons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>

    <style>
        :root {
            --primary-purple: #7B61FF;
            --light-purple: #F0EEFF;
            --background-light: #F4F6F9;
            --text-dark: #1E2022;
            --text-muted: #6A737D;
            --white: #FFFFFF;
            --green: #25D366;
            --blue: #1DA1F2;
            
            /* ফুটারের জন্য ডার্ক থিম ভ্যারিয়েবল */
            --bg-dark: #161922;
            --bg-card: #252836;
            --secondary-color: #50E3C2;
        }

        body {
            margin: 0;
            font-family: 'Poppins', sans-serif;
            background-color: var(--background-light);
            color: var(--text-dark);
            padding: 15px;
            padding-bottom: 95px; /* ফুটারের জন্য জায়গা */
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        .close-btn {
            font-size: 14px;
            font-weight: 500;
            color: var(--text-muted);
            background-color: #e9ecef;
            padding: 8px 15px;
            border-radius: 20px;
            text-decoration: none;
        }
        .close-btn i { margin-right: 5px; }
        .user-info {
            display: flex;
            align-items: center;
        }
        .user-info img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            margin-right: 10px;
        }
        .user-info .name { font-weight: 600; }
        .user-info .balance { font-size: 0.9em; color: var(--text-muted); }

        .card {
            background: var(--white);
            border-radius: 20px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.05);
            position: relative;
        }
        .card-title {
            font-size: 1.5em;
            font-weight: 700;
            margin: 0 0 10px 0;
        }
        .percent-badge {
            position: absolute;
            top: 20px;
            right: 20px;
            background-color: var(--light-purple);
            color: var(--primary-purple);
            font-weight: 600;
            padding: 5px 10px;
            border-radius: 8px;
            font-size: 0.9em;
        }
        .card p { color: var(--text-muted); line-height: 1.6; }

        .step {
            display: flex;
            align-items: center;
            margin-top: 20px;
        }
        .step-icon {
            width: 45px;
            height: 45px;
            background-color: var(--light-purple);
            border-radius: 50%;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 20px;
            color: var(--primary-purple);
            margin-right: 15px;
            flex-shrink: 0;
        }
        .step-text strong {
            display: block;
            font-weight: 600;
            color: var(--text-dark);
        }
        .step-text span {
            font-size: 0.9em;
            color: var(--text-muted);
        }

        .referral-link-title {
            font-weight: 600;
            margin-top: 25px;
            margin-bottom: 10px;
        }
        .referral-link-wrapper {
            position: relative;
        }
        #referralLinkInput {
            width: 100%;
            background-color: var(--background-light);
            border: 1px solid #e0e0e0;
            border-radius: 12px;
            padding: 15px;
            padding-right: 45px;
            font-size: 1em;
            color: var(--text-dark);
            box-sizing: border-box;
            font-family: 'Poppins', sans-serif;
        }
        .copy-icon {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 18px;
            color: var(--text-muted);
            cursor: pointer;
        }

        .share-buttons {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            margin-top: 20px;
        }
        .share-btn {
            padding: 12px;
            border-radius: 12px;
            text-align: center;
            font-weight: 600;
            text-decoration: none;
            color: var(--white);
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .share-btn i { margin-right: 8px; }
        .btn-telegram { background-color: var(--primary-purple); }
        .btn-whatsapp { background-color: var(--green); }
        .btn-twitter { background-color: var(--blue); }

        .search-bar { position: relative; }
        .search-bar input {
            width: 100%;
            padding: 15px 15px 15px 45px;
            border: 1px solid #e0e0e0;
            border-radius: 12px;
            background: var(--background-light);
            font-family: 'Poppins', sans-serif;
        }
        .search-bar i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-muted);
        }

        /* আপনার index.php থেকে আনা ফুটার স্টাইল */
        footer {
            position: fixed; bottom: 0; left: 0; right: 0; background: var(--bg-card);
            display: flex; justify-content: space-around; align-items: center;
            padding: 10px 0; border-top-left-radius: 25px; border-top-right-radius: 25px;
            box-shadow: 0 -5px 20px rgba(0,0,0,0.2);
        }
        footer a { color: var(--text-muted); text-decoration: none; font-size: 24px; }
        footer a.active { color: var(--secondary-color); }
        .nav-item-main {
            background: var(--secondary-color); color: var(--bg-dark); width: 60px; height: 60px;
            border-radius: 50%; display: flex; justify-content: center; align-items: center;
            transform: translateY(-25px); border: 5px solid var(--bg-dark);
        }
    </style>
</head>
<body>

    <div class="header">
        <a href="index.php?user_id=<?php echo $user_id; ?>" class="close-btn"><i class="fas fa-times"></i> Close</a>
        <div class="user-info">
            <img src="<?php echo htmlspecialchars($user['profile_photo_url'] ?? 'assets/default_avatar.png'); ?>" alt="Profile">
            <div>
                <div class="name"><?php echo htmlspecialchars($user['first_name']); ?></div>
                <div class="balance">Balance: <?php echo number_format($user['total_balance'], 2); ?> SHIB</div>
            </div>
        </div>
    </div>

    <div class="card">
        <h2 class="card-title">Refer & Earn Forever</h2>
        <span class="percent-badge">20%</span>
        <p>Earn 20% of your friends earnings for life! Follow these simple steps to start:</p>

        <div class="steps-container">
            <div class="step">
                <div class="step-icon"><i class="fa-solid fa-link"></i></div>
                <div class="step-text">
                    <strong>1. Copy Your Link</strong>
                    <span>Grab your unique referral link below.</span>
                </div>
            </div>
            <div class="step">
                <div class="step-icon"><i class="fa-solid fa-share-nodes"></i></div>
                <div class="step-text">
                    <strong>2. Share with Friends</strong>
                    <span>Use the Telegram, WhatsApp, or Twitter/X buttons to share your link.</span>
                </div>
            </div>
            <div class="step">
                <div class="step-icon"><i class="fa-solid fa-coins"></i></div>
                <div class="step-text">
                    <strong>3. Earn Lifetime Rewards</strong>
                    <span>Get 20% of your friends earnings forever once they join!</span>
                </div>
            </div>
        </div>

        <h3 class="referral-link-title">Your Referral Link</h3>
        <div class="referral-link-wrapper">
            <input type="text" id="referralLinkInput" value="<?php echo htmlspecialchars($referral_link); ?>" readonly>
            <i class="fa-regular fa-copy copy-icon" onclick="copyLink()"></i>
        </div>

        <div class="share-buttons">
            <a href="https://t.me/psupdateLAB" class="share-btn btn-telegram" onclick="shareOnTelegram()">
                <i class="fab fa-telegram-plane"></i> Telegram
            </a>
            <a href="https://wa.me/8801819168773" class="share-btn btn-whatsapp" onclick="shareOnWhatsApp()">
                <i class="fab fa-whatsapp"></i> WhatsApp
            </a>
            <a href="https://wa.me/8801819168773" class="share-btn btn-twitter" onclick="shareOnTwitter()">
                <i class="fab fa-twitter"></i> Twitter/X
            </a>
        </div>
    </div>

    <div class="card">
        <h2 class="card-title">Referrals List</h2>
        <div class="search-bar">
            <i class="fas fa-search"></i>
            <input type="text" placeholder="Search referrals by username...">
        </div>
        <!-- এখানে রেফারেলদের লিস্ট দেখানো হবে -->
    </div>

    <!-- আপনার ডার্ক থিমের ফুটার -->
    <footer>
        <a href="index.php?user_id=<?php echo $user_id; ?>">🏠</a>
        <a href="wallet.php?user_id=<?php echo $user_id; ?>">💼</a>
        <a href="refer.php?user_id=<?php echo $user_id; ?>" class="nav-item-main active">⇄</a>
        <a href="profile.php?user_id=<?php echo $user_id; ?>">👤</a>
        <a href="settings.php?user_id=<?php echo $user_id; ?>">⚙️</a>
    </footer>

    <script>
        const tg = window.Telegram.WebApp;
        tg.ready();
        
        // হেডার রঙ পরিবর্তন করা হচ্ছে কারণ এই পেজের ব্যাকগ্রাউন্ড হালকা
        tg.setHeaderColor('#F4F6F9');

        const referralLink = document.getElementById('referralLinkInput').value;
        const shareText = encodeURIComponent(`Hey! Join me and earn crypto. Here is my referral link: ${referralLink}`);

        function copyLink() {
            const input = document.getElementById('referralLinkInput');
            input.select();
            input.setSelectionRange(0, 99999); // For mobile devices
            
            try {
                navigator.clipboard.writeText(input.value);
                tg.showAlert('Referral link copied to clipboard!');
            } catch (err) {
                tg.showAlert('Failed to copy the link.');
            }
        }

        function shareOnTelegram() {
            tg.openTelegramLink(`https://t.me/share/url?url=${referralLink}&text=${shareText}`);
        }

        function shareOnWhatsApp() {
            window.open(`https://api.whatsapp.com/send?text=${shareText}`, '_blank');
        }

        function shareOnTwitter() {
            window.open(`https://twitter.com/intent/tweet?text=${shareText}`, '_blank');
        }

    </script>
</body>
</html>
<?php
$conn->close();
?>