<?php
// =================================================================
// SETTINGS PAGE (আপনার সকল চাহিদা অনুযায়ী চূড়ান্ত সংস্করণ)
// =================================================================
session_start();
require_once '../config.php';
$conn = require_once '../db.php';

// --- পেজ প্রদর্শনের লজিক ---
$chat_id = filter_input(INPUT_GET, 'user_id', FILTER_SANITIZE_NUMBER_INT);
if (!$chat_id) die("সঠিক ব্যবহারকারী আইডি পাওয়া যায়নি।");

$stmt_user = $conn->prepare("SELECT * FROM users WHERE chat_id = ?");
$stmt_user->bind_param('i', $chat_id);
$stmt_user->execute();
$user = $stmt_user->get_result()->fetch_assoc();
if (!$user) die("ব্যবহারকারীকে খুঁজে পাওয়া যায়নি।");

$total_balance = $user['total_balance'] ?? 0;
// ডেভেলপার কন্টাক্ট লিঙ্ক
$developer_telegram_link = "https://t.me/psupdateLAB";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, viewport-fit=cover">
    <title>Settings</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://telegram.org/js/telegram-web-app.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    <style>
        :root {
            --background-light: #F4F6F9; --white: #FFFFFF; --text-dark: #1E2022;
            --text-muted: #6A737D; --primary-color: #007BFF; --danger-color: #dc3545;
            /* Footer Dark Theme */
            --bg-dark: #161922; --bg-card: #252836; --footer-active: #50E3C2;
            /* Stat Colors */
            --color-monetag: #20c997; --color-adsterra: #fd7e14;
            --color-telegram: #007bff; --color-gigapub: #6f42c1;
            --color-referral: #ffc107; --color-withdraw: #17a2b8;
        }
        body { margin: 0; font-family: 'Poppins', sans-serif; background-color: var(--background-light); color: var(--text-dark); padding: 15px; padding-bottom: 95px; }
        a { text-decoration: none; color: inherit; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .header .title { font-size: 1.2em; font-weight: 600; }
        
        .profile-card {
            background: linear-gradient(135deg, #6f42c1, #4a90e2);
            color: var(--white);
            border-radius: 20px;
            padding: 20px;
            display: flex;
            align-items: center;
            margin-bottom: 25px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.15);
        }
        .profile-card img { width: 60px; height: 60px; border-radius: 50%; margin-right: 15px; border: 3px solid rgba(255,255,255,0.5); }
        .profile-card .name { font-weight: 600; font-size: 1.2em; }
        .profile-card .balance { font-size: 1em; opacity: 0.9; }

        .section-title { font-size: 1.2em; font-weight: 600; margin-bottom: 15px; }

        .stats-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; }
        .stat-box {
            background: var(--white);
            padding: 20px;
            border-radius: 15px;
            text-align: center;
            border-left: 5px solid;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        .stat-box:hover { transform: translateY(-5px); box-shadow: 0 8px 25px rgba(0,0,0,0.1); }
        .stat-box .icon { font-size: 1.8em; margin-bottom: 10px; }
        .stat-box .label { font-size: 0.9em; font-weight: 500; color: var(--text-muted); }
        .stat-box .value { font-size: 1.6em; font-weight: 700; margin-top: 5px; }
        
        /* Dynamic Border Colors */
        .stat-box.monetag { border-color: var(--color-monetag); } .stat-box.monetag .icon, .stat-box.monetag .value { color: var(--color-monetag); }
        .stat-box.adsterra { border-color: var(--color-adsterra); } .stat-box.adsterra .icon, .stat-box.adsterra .value { color: var(--color-adsterra); }
        .stat-box.telegram { border-color: var(--color-telegram); } .stat-box.telegram .icon, .stat-box.telegram .value { color: var(--color-telegram); }
        .stat-box.gigapub { border-color: var(--color-gigapub); } .stat-box.gigapub .icon, .stat-box.gigapub .value { color: var(--color-gigapub); }
        .stat-box.referral { border-color: var(--color-referral); } .stat-box.referral .icon, .stat-box.referral .value { color: var(--color-referral); }
        .stat-box.withdraw { border-color: var(--color-withdraw); } .stat-box.withdraw .icon, .stat-box.withdraw .value { color: var(--color-withdraw); }

        .action-links { margin-top: 25px; }
        .action-links a {
            display: flex;
            align-items: center;
            padding: 16px;
            background: var(--white);
            border-radius: 12px;
            margin-bottom: 10px;
            font-weight: 600;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        .action-links a:hover { transform: translateY(-3px); box-shadow: 0 6px 20px rgba(0,0,0,0.08); }
        .action-links .icon { width: 25px; text-align: center; margin-right: 15px; font-size: 1.2em; }
        .action-links .developer .icon { color: var(--primary-color); }
        .action-links .logout .icon { color: var(--danger-color); }

        /* Footer */
        footer { position: fixed; bottom: 0; left: 0; right: 0; background: var(--bg-card); display: flex; justify-content: space-around; align-items: center; padding: 10px 0; border-top-left-radius: 25px; border-top-right-radius: 25px; box-shadow: 0 -5px 20px rgba(0,0,0,0.2); }
        footer a { color: var(--text-muted); text-decoration: none; font-size: 24px; text-align: center; flex-grow: 1; }
        footer a .label { font-size: 11px; display: block; margin-top: 2px; }
        footer a.active, footer a.active .label { color: var(--footer-active); }
    </style>
</head>
<body>
    <div class="header">
        <h2 class="title">Settings</h2>
    </div>

    <div class="profile-card">
        <img src="<?php echo htmlspecialchars($user['profile_photo_url'] ?? 'assets/default_avatar.png'); ?>" alt="Profile">
        <div>
            <div class="name"><?php echo htmlspecialchars($user['first_name']); ?></div>
            <div class="balance">Balance: <?php echo number_format($total_balance, 2); ?> BDT</div>
        </div>
    </div>

    <h3 class="section-title">Task Statistics</h3>
    <div class="stats-grid">
        <div class="stat-box monetag">
            <div class="icon"><i class="fas fa-layer-group"></i></div>
            <div class="label">Monetag Tasks</div>
            <div class="value"><?php echo (int)($user['monetag_tasks_done'] ?? 0); ?></div>
        </div>
        <div class="stat-box adsterra">
            <div class="icon"><i class="fas fa-bullhorn"></i></div>
            <div class="label">Adsterra Tasks</div>
            <div class="value"><?php echo (int)($user['adsterra_tasks_done'] ?? 0); ?></div>
        </div>
        <div class="stat-box telegram">
            <div class="icon"><i class="fab fa-telegram-plane"></i></div>
            <div class="label">Telegram Tasks</div>
            <div class="value"><?php echo (int)($user['telegram_tasks_done'] ?? 0); ?></div>
        </div>
        <div class="stat-box gigapub">
            <div class="icon"><i class="fas fa-file-alt"></i></div>
            <div class="label">Gigapub Tasks</div>
            <div class="value"><?php echo (int)($user['gigapub_tasks_done'] ?? 0); ?></div>
        </div>
    </div>
    
    <h3 class="section-title" style="margin-top: 25px;">Account Statistics</h3>
    <div class="stats-grid">
        <div class="stat-box referral">
            <div class="icon"><i class="fas fa-users"></i></div>
            <div class="label">Total Referrals</div>
            <div class="value"><?php echo (int)($user['total_referrals'] ?? 0); ?></div>
        </div>
        <div class="stat-box withdraw">
            <div class="icon"><i class="fas fa-wallet"></i></div>
            <div class="label">Total Withdrawn</div>
            <div class="value"><?php echo number_format($user['total_withdrawn'] ?? 0, 2); ?></div>
        </div>
    </div>

    <div class="action-links">
        <a href="<?php echo $developer_telegram_link; ?>" class="developer">
            <i class="fab fa-telegram-plane icon"></i> Developer Contact
        </a>
        <a href="#" class="logout" onclick="confirmLogout()">
            <i class="fas fa-sign-out-alt icon"></i> Log Out
        </a>
    </div>

    <!-- ফুটার -->
    <footer>
        <a href="index.php?user_id=<?php echo $chat_id; ?>"><i class="fas fa-home"></i><span class="label">Home</span></a>
        <a href="#"><i class="fas fa-ad"></i><span class="label">Ads Task</span></a>
        <a href="#"><i class="fas fa-tasks"></i><span class="label">TG Tasks</span></a>
        <a href="refer.php?user_id=<?php echo $chat_id; ?>"><i class="fas fa-users"></i><span class="label">Refer</span></a>
        <a href="wallet.php?user_id=<?php echo $chat_id; ?>"><i class="fas fa-wallet"></i><span class="label">Withdraw</span></a>
        <a href="profile.php?user_id=<?php echo $chat_id; ?>"><i class="fas fa-user"></i><span class="label">Profile</span></a>
        <!-- সেটিংস পেজের জন্য একটি নতুন আইকন যোগ করা হলো -->
        <a href="settings.php?user_id=<?php echo $chat_id; ?>" class="active"><i class="fas fa-cog"></i><span class="label">Settings</span></a>
    </footer>

    <script>
        const tg = window.Telegram.WebApp;
        tg.ready();
        tg.setHeaderColor('#F4F6F9');

        function confirmLogout() {
            tg.showConfirm("Are you sure you want to log out?", function(isConfirmed) {
                if (isConfirmed) {
                    // এখানে লগ-আউটের আসল কোড থাকবে
                    // আপাতত, আমরা শুধু অ্যাপটি বন্ধ করে দিচ্ছি
                    tg.showAlert("You have been logged out.");
                    tg.close();
                }
            });
        }
    </script>
</body>
</html>
<?php
$conn->close();
?>